﻿' ----------------------------------------------------------------------------
' Calendar object class
' ----------------------------------------------------------------------------
Type TCalendar

	Field x:Int
	Field y:Int
	Field w:Int
	Field h:Int
	
	Field color:Int[] = [0, 255, 0, 200]
	Field back:Int[] = [0, 64, 0, 128]
	Field border:Int[] = [0, 0, 0, 128]
	Field hover:Int[] = [255, 255, 255, 255]
	Field selected:Int[] = [255, 255, 255, 255]

	' settable date
	Field dd:Int = 0
	Field mm:Int = 0
	Field yy:Int = 0

	' holds current timestamp
	Field curdate:String
	
	' holds current year (YYYY), month (MM) and day (DD)
	Field curyear:Int
	Field curmonth:Int
	Field curday:Int
	
	' holds the day array of the created calendar [0...41] = (6 weeks à 7 days)
	Field caldays:Int[]
	
	' holds the current weekday of dd,mm,yyyy (0=Monday, 6=Sunday)
	Field weekday:Int

	' number of days and month names
	Field days:Int[] = [0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]
	Field arrstart:Int
	Field arrend:Int
	
	Field out:String

	' creates the calendar
	Method Create()

		' previous month and year
		Local py:Int
		Local pm:Int
		
		' next month and year
		Local ny:Int
		Local nm:Int
		
		' previous, current, next month days
		Local dpm:Int
		Local dmm:Int
		Local dnm:Int
	
		' get current date from OS
		curdate = FTimestamp(GetTimeStamp(), "%Y%m%d")
		curyear = Int(Mid(curdate, 1, 4))
		curmonth = Int(Mid(curdate, 5, 2))
		curday = Int(Mid(curdate, 7, 2))

		' if date is not set yet use OS date
		If yy = 0 Then yy = curyear
		If mm = 0 Then mm = curmonth
		If dd = 0 Then dd = curday

		' wrap previous month+year
		py = yy
		pm = mm - 1
		If pm < 1 Then pm = 12 ; py:-1
		
		' wrap next month+year
		ny = yy
		nm = mm + 1
		If nm > 12 Then nm = 1 ; py:+1
		
		' determine days of previous month
		days[2] = FixLeapYear(py)
		dpm = days[pm]
		
		' determine days of current month
		days[2] = FixLeapYear(yy)
		dmm = days[mm]
		weekday = GetWeekDay(yy, mm, 1) Mod 7
		
		' determine days of next month
		days[2] = FixLeapYear(ny)
		dnm = days[nm]
		
		' prepare 3-month-array, counter and positions
		Local darray:Int[dpm + dmm + dnm]
		Local c:Int = 0
		Local dstart:Int = 0
		Local dend:Int = 0
		
		' add previous month days
		For Local i:Int = 1 To days[pm]
		
			darray[c] = i
			c:+1
			
		Next
		
		' add current month days
		For Local i:Int = 1 To days[mm]
		
			' start is the first day of the current month minus the weekday
			If i = 1 Then dstart = c - weekday
			darray[c] = i
			c:+1
			
		Next
	
		' add next month days
		For Local i:Int = 1 To days[nm]
		
			darray[c] = i
			c:+1
			
		Next
		
		' add 6 rows of 7 days, 6x7=42 = end
		dend = dstart + 42
		
		' slice visible time range from array
		caldays = darray[dstart..dend]
		
		arrstart = weekday
		arrend = arrstart + days[mm] - 1
					
	End Method

	' output formatted day
	Method FormatDay:String(d:Int)
	
		Local day:String = d + " "
		If d < 10 Then day = " " + d + " "
		
		Return day
	
	End Method
	
	' get day of week for a given date (0-6, 0=Monday)
	Method GetWeekDay:Int(y:Int, m:Int, d:Int)
	
		Local t:Int[] = [0, 3, 2, 5, 0, 3, 5, 1, 4, 6, 2, 4]
	
		If m < 3 Then y:-1
		
		Return ((y + y / 4 - y / 100 + y / 400 + t[m - 1] + d) - 1) Mod 7
		
	End Method
	
	' fix leap years in months array
	Method FixLeapYear:Int(year:Int)
	
		If ((year Mod 4) = 0 And (year Mod 100) <> 0) Or ((year Mod 4) = 0 And (year Mod 400) = 0) Then
				
			Return 29
		
		Else
			
			Return 28
			
		EndIf
		
	End Method
	
	' returns formatted time string
	Method FTimestamp:String(timestamp:Int, format:String = "%Y-%m-%d %H:%M:%S")
	
		Local time:Int Ptr, buff:Byte[256]
		
		time = VarPtr(timestamp)
		strftime_(buff, 256, format, localtime_(time))
		
		Return String.FromCString(buff)
		
	End Method
	
	' get current UNIX timestamp from OS
	Method GetTimeStamp:Int()
	
		Local time:Int[256]
		time_(time)
		return time[0]
	
	End Method
	
	' returns the exact! unix timestamp for given YEARS,MONTHS,DAYS,HOURS,MINUTES,SECONDS (not used in this example)
	Method GetUnixTimestamp:Int(yy:Int, mm:Int, dd:Int, hh:Int, ii:Int, ss:Int)
	
		Local days:Int[] = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334]
	 	Local years:Int = yy - 1970
		Local leap:Int = ((yy - 1) - 1968) / 4 - ((yy - 1) - 1900) / 100 + ((yy - 1) - 1600) / 400
		
		Local unixtime:Int = ss + 60 * ii + 60 * 60 * hh + (days[mm - 1] + dd - 1) * 60 * 60 * 24 + (years * 365 + leap) * 60 * 60 * 24
	 
	  	If ((mm > 2) And (yy Mod 4 = 0 And (yy Mod 100 <> 0 Or yy Mod 400 = 0))) Then
		
	    	' leap day
			unixtime:+(60 * 60 * 24)
			
		End If
	 
	  Return unixtime
	
	End Method

End Type

' ----------------------------------------------------------------------------
' clickable area class object for calendar
' ----------------------------------------------------------------------------
Type TClick

	Field x:Int
	Field y:Int
	Field w:Int
	Field h:Int
	
	Field gadget:TGadget
	Field hover:Int
	Field clicked:Int
	Field Key:String
	Field val:String
	Field cal:TCalendar
	Field clicktimer:Int = 500
		
	Method Add(gadget:TGadget, Key:String, val:String, cal:TCalendar, x:Int, y:Int, w:Int, h:Int)
	
		Local t:TClick = New TClick
		
		t.x = x
		t.y = y
		t.w = w
		t.h = h
		
		t.Key = Key
		t.val = val
		t.cal = cal
		
		t.gadget = gadget
		
		ListAddLast(clicklist, t)
	
	End Method
	
	Method Check(gadget:TGadget)
	
		hover = False
		clicked = False
									
		If MX > x And MX < x + w And MY > y And MY < y + h And Self.gadget = gadget Then
		
			hover = True
			If MouseButtondown Then clicked = True
			
		EndIf
			
	End Method
	
	Method Update()
			
		cal.out = ""
		
		If hover Then
		
			cal.out = cal.caldays[Int(val)]
			
			If cal.caldays[Int(val)] < 10 Then cal.out = " " + cal.out
						
		EndIf
			
	End Method

End Type